@extends('admin.layouts.master')

@section('extra_css')
    <link rel="stylesheet" type="text/css" href="/assets/plugins/bootstrap-datepicker/css/bootstrap-datepicker3.min.css"/>

@stop

@section('extra_js')
    <script type="text/javascript" src="/assets/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>

    <script type="text/javascript">
        $('.date-picker').datepicker({
            orientation: "left",
            autoclose: true
        });
    </script>
@stop

@section('content')

    <h3 class="page-title">
        Users <small>Manage Users</small>
    </h3>

    <div class="page-bar">
        <ul class="page-breadcrumb">

            <li>
                <a href="/admin">Home</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href="/admin/users">Users</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href="/admin/users/edit/{{$user->id}}">Edit {{$user->name}}</a>
            </li>
        </ul>
    </div>


    <!-- END PAGE HEADER-->
    <!-- BEGIN PAGE CONTENT-->
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN PORTLET-->
            <div class="portlet box green-meadow">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-puzzle"></i>Edit User - {{$user->name}}
                    </div>
                    <div class="tools">
                        <a href="javascript:;" class="collapse">
                        </a>
                    </div>
                </div>

                <div class="portlet-body form">


                    <form action="/admin/users/update" enctype="multipart/form-data" method="post" class="form-horizontal form-bordered">

                        <div class="form-group">
                            <label class="col-sm-3 control-label"></label>

                            <div class="col-sm-4">
                                @include('admin.layouts.notify')
                            </div>
                        </div>

                        <input type="hidden" name="_token" value="{{csrf_token()}}"/>
                        <input type="hidden" name="id" value="{{$user->id}}"/>

                        <div class="form-group">
                            <label for="name" class="col-sm-3 control-label">Name</label>

                            <div class="col-sm-8">
                                <input id="name" class="form-control" type="text" name="name"
                                       placeholder="Enter name" value="{{old('name',$user->name)}}"/>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="email" class="col-sm-3 control-label">Email</label>

                            <div class="col-sm-8">
                                <input id="email" class="form-control" type="email" name="email"
                                       placeholder="Enter email" value="{{old('email',$user->email)}}"/>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="password" class="col-sm-3 control-label">Password</label>

                            <div class="col-sm-8">
                                <input id="password" class="form-control" type="password" name="password"
                                       placeholder="Enter password" />
                                <span class="help-block">
											Leave it blank , if you dont want to change password </span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="password_confirmation" class="col-sm-3 control-label">Confirm Password</label>

                            <div class="col-sm-8">
                                <input id="password_confirmation" class="form-control" type="password" name="password_confirmation"
                                       placeholder="Confirm password" />
                                 <span class="help-block">
											Leave it blank , if you dont want to change password </span>
                            </div>
                        </div>


                        <div class="form-group">
                            <label for="avatar" class="col-sm-3 control-label">Avatar</label>

                            <div class="col-sm-8">
                                <input id="avatar" class="form-control" type="file" name="avatar" />
                                <input type="hidden" name="old_avatar" value="{{$user->avatar}}"/>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-sm-8 col-sm-offset-3">
                                <img style="width:100px;" src="{{$user->avatar}}"/>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="dob" class="col-sm-3 control-label">Date of Birth</label>

                            <div class="col-sm-8">
                                <input id="dob" class="form-control date-picker" type="text" name="dob" value="{{$user->birthday}}"/>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="bio" class="col-sm-3 control-label">Bio</label>

                            <div class="col-sm-8">
                                <textarea id="bio" class="form-control" name="bio" >{{$user->bio}}</textarea>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="gender" class="col-sm-3 control-label">Gender</label>

                            <div class="col-sm-8">
                                <select id="gender" class="form-control" name="gender">
                                    <option {{$user->gender == \App\Users::GENDER_MALE ? "selected":""}} value="{{\App\Users::GENDER_MALE}}">Male</option>
                                    <option {{$user->gender == \App\Users::GENDER_FEMALE? "selected":""}} value="{{\App\Users::GENDER_FEMALE}}">Female</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="mobile_no" class="col-sm-3 control-label">Mobile No</label>

                            <div class="col-sm-8">
                                <input id="mobile_no" class="form-control" type="text" name="mobile_no" value="{{$user->mobile_no}}"/>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="fb_url" class="col-sm-3 control-label">Facebook URL</label>

                            <div class="col-sm-8">
                                <input id="fb_url" class="form-control" type="text" name="fb_url"
                                       placeholder="Enter facebook url" value="{{old('fb_url',$user->fb_url)}}"/>
                                <span class="help-block"> URL should start with http:// or https://</span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="fb_page_url" class="col-sm-3 control-label">Facebook Page URL</label>

                            <div class="col-sm-8">
                                <input id="fb_page_url" class="form-control" type="text" name="fb_page_url"
                                       placeholder="Enter facebook page url" value="{{old('fb_page_url',$user->fb_page_url)}}"/>
                                <span class="help-block"> URL should start with http:// or https://</span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="website_url" class="col-sm-3 control-label">Website URL</label>

                            <div class="col-sm-8">
                                <input id="website_url" class="form-control" type="text" name="website_url"
                                       placeholder="Enter website url" value="{{old('website_url',$user->website_url)}}"/>
                                <span class="help-block"> URL should start with http:// or https://</span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="twitter_url" class="col-sm-3 control-label">Twitter URL</label>

                            <div class="col-sm-8">
                                <input id="twitter_url" class="form-control" type="text" name="twitter_url"
                                       placeholder="Enter twitter url" value="{{old('twitter_url',$user->twitter_url)}}"/>
                                <span class="help-block"> URL should start with http:// or https://</span>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="google_plus_url" class="col-sm-3 control-label">Google Plus URL</label>

                            <div class="col-sm-8">
                                <input id="google_plus_url" class="form-control" type="text" name="google_plus_url"
                                       placeholder="Enter google plus url" value="{{old('google_plus_url',$user->google_plus_url)}}"/>
                                <span class="help-block"> URL should start with http:// or https://</span>
                            </div>
                        </div>


                        <div class="form-group">
                            <label for="country" class="col-sm-3 control-label">Country</label>

                            <div class="col-sm-8">
                                <select id="country" name="country" class="form-control">
                                    @foreach($countries as $country)
                                        <option {{$country->id == $user->country ? "selected":""}} value="{{$country->id}}">{{$country->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="type" class="col-sm-3 control-label">Type</label>

                            <div class="col-sm-8">
                                <select id="type" class="form-control" name="type">
                                    @foreach($groups as $group)
                                        <option {{$group->id == $user->group->group_id ? "selected":""}} value="{{$group->id}}">{{ucfirst($group->name)}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="form-group">

                            <div class="col-md-offset-3 col-md-8">
                                <div class="checkbox">
                                    <label>
                                        <input name="activate" type="checkbox" {{$user->activated == 1 ? "checked":""}}> Activate </label>
                                </div>
                            </div>

                        </div>


                        <div class="form-actions">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                    <button type="submit" class="btn purple"><i class="fa fa-check"></i> Save</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!-- END PORTLET-->
        </div>
    </div>
@stop